﻿/*
 * Copyright 2019,2020,2021,2022 Sony Corporation
 */

using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.Events;

namespace SRD.Sample.Home
{
    public class SRDSampleScenesController : MonoBehaviour
    {
        private bool _isTransitioning = false;

        private static SRDSampleScenesController _instance;
        public static SRDSampleScenesController Instance
        {
            get
            {
                if(_instance != null)
                {
                    return _instance;
                }

                _instance = (SRDSampleScenesController)FindObjectOfType(typeof(SRDSampleScenesController));
                if(_instance == null)
                {
                    var go = new GameObject("SRDSampleScenesController");
                    go.transform.parent = null;
                    go.transform.SetPositionAndRotation(Vector3.zero, Quaternion.identity);
                    _instance = go.AddComponent<SRDSampleScenesController>();
                }
                return _instance;
            }
        }

        private Dictionary<KeyCode, string> _keyToSceneName;

        void Awake()
        {
            if(this != Instance)
            {
                Destroy(this.gameObject);
                return;
            }
            DontDestroyOnLoad(this.gameObject);
        }

        void Start()
        {
            _keyToSceneName = new Dictionary<KeyCode, string>()
            {
                {KeyCode.Alpha1, "SRDisplaySimpleSample" },
                {KeyCode.Alpha2, "SRDisplayLookAtSample" },
                {KeyCode.Alpha3, "SRDisplayUISample" },
                {KeyCode.Alpha4, "SRDisplayPostProcessingSample" },
                {KeyCode.Alpha5, "SRDisplay3DRaycastSample" },
                {KeyCode.Alpha0, "SRDisplaySampleHome" },
            };

            SceneManager.sceneLoaded += OnSceneLoaded;
        }

        private void OnSceneLoaded(Scene scene, LoadSceneMode mode)
        {
            StartCoroutine("WaitAfterSceneLoaded");
        }

        private IEnumerator WaitAfterSceneLoaded()
        {
            yield return new WaitForSeconds(0.5f);
            _isTransitioning = false;
        }

        void Update()
        {
            if(_isTransitioning)
            {
                return;
            }

            foreach(var kts in _keyToSceneName)
            {
                if(Input.GetKeyDown(kts.Key))
                {
                    SceneManager.LoadScene(kts.Value);
                    _isTransitioning = true;
                }
            }
        }

        void OnDestroy()
        {
            SceneManager.sceneLoaded -= OnSceneLoaded;

            if(this == Instance)
            {
                _instance = null;
            }
        }

    }
}
