﻿/*
 * Copyright 2019,2020,2021 Sony Corporation
 */


using UnityEngine;

namespace SRD.XR.Core
{
    public class SRDisplayXRUtils
    {
        public static class Constrains
        {
            static public readonly string MainCamName = "SRDisplayXR Main Camera";
        }

        public static class Constants
        {
            public const string SRDProjectSettingsAssetPath = "Assets/SRDisplayXRUnityPlugin/Resources/SRDisplayXRProjectSettings.asset";

            public const string NativePluginDLLName = "SRDisplayXRNativePlugin";
        }

        [System.Serializable]
        public class BodyBounds
        {
            public static readonly float DefaultWidth = 0.345f;
            public static readonly float DefaultHeight = 0.137f;
            public static readonly float DefaultDepth = 0.137f;

            public BodyBounds() : this(BodyBounds.DefaultWidth, BodyBounds.DefaultHeight, BodyBounds.DefaultDepth)
            {
                // do nothing
            }

            public BodyBounds(float width, float height, float depth)
            {
                _width = width;
                _height = height;
                _depth = depth;

                _leftUp = new Vector3(-this.Width / 2f, this.Height, this.Depth);
                _leftBottom = new Vector3(-this.Width / 2f, 0.0f, 0.0f);
                _rightUp = new Vector3(this.Width / 2f, this.Height, this.Depth);
                _rightBottom = new Vector3(this.Width / 2f, 0.0f, 0.0f);
                _center = new Vector3(0f, this.Height / 2f, this.Depth / 2f);
                _boxSize = new Vector3(this.Width, this.Height, this.Depth);
            }

            public BodyBounds(Rect rect, float tiltRad) : this(rect.width, rect.height * Mathf.Sin(tiltRad), rect.height * Mathf.Cos(tiltRad))
            {
                // do nothing
            }

            [SerializeField]
            private float _width;
            public float Width { get { return _width; } }
            [SerializeField]
            private float _height;
            public float Height { get { return _height; } }
            [SerializeField]
            private float _depth;
            public float Depth { get { return _depth; } }

            // in PositionTrackingCoord
            private Vector3 _leftUp;
            public Vector3 LeftUp { get { return _leftUp; } }
            private Vector3 _leftBottom;
            public Vector3 LeftBottom { get { return _leftBottom; } }
            private Vector3 _rightUp;
            public Vector3 RightUp { get { return _rightUp; } }
            private Vector3 _rightBottom;
            public Vector3 RightBottom { get { return _rightBottom; } }

            public Vector3[] EdgePositions { get { return new Vector3[] { this.LeftUp, this.LeftBottom, this.RightBottom, this.RightUp }; } }

            private Vector3 _center;
            public Vector3 Center { get { return _center; } }
            private Vector3 _boxSize;
            public Vector3 BoxSize { get { return _boxSize; } }
        }

    }
}
