﻿/*
 * Copyright 2019,2020,2021 Sony Corporation
 */

using UnityEngine;

using SRD.XR.Core;

namespace SRD.XR.Utils
{
    public partial class SRDisplayXRSettings
    {
        public static bool Load()
        {
            return SRDDeviceInfo.Load();
        }

        public static bool LoadScreenRect()
        {
            return SRDDeviceInfo.LoadScreenRect();
        }

        public static SRDDeviceInfo DeviceInfo { get { return SRDDeviceInfo.Instance; } }

        public class SRDDeviceInfo
        {
            private static SRDDeviceInfo instance = new SRDDeviceInfo();
            public static SRDDeviceInfo Instance { get { return instance; } }

            private static ScreenRect _screenRect;
            public ScreenRect ScreenRect { get { return _screenRect; } }

            public static bool Load()
            {
                var resSR = LoadScreenRect();
                return resSR;
            }

            public static bool LoadScreenRect()
            {
                var screenRect = loadScreenRect();
                if(screenRect == null)
                {
                    _screenRect = getDefaultScreenRect();
                    return false;
                }
                _screenRect = screenRect;
                return true;
            }

            private SRDDeviceInfo(ScreenRect resolution)
            {
                _screenRect = resolution;
            }

            private SRDDeviceInfo() : this(new ScreenRect())
            {
                // do nothing
            }

            private static SRDDeviceInfo getDefault()
            {
                return new SRDDeviceInfo(getDefaultScreenRect());
            }

            private static ScreenRect getDefaultScreenRect()
            {
                return new ScreenRect();
            }

            private static ScreenRect loadScreenRect()
            {
                ScreenRect screenRect;
                if(!SRDisplayXrCorePlugin.GetSRDScreenRect(out screenRect))
                {
                    return null;
                }
                return screenRect;
            }
        }

        [System.Serializable]
        public class ScreenRect
        {
            public static readonly int DefaultWidth = 3840;
            public static readonly int DefaultHeight = 2160;
            public static readonly int DefaultLeft = 0;
            public static readonly int DefaultTop = 0;

            public ScreenRect() : this(ScreenRect.DefaultLeft, ScreenRect.DefaultTop,
                                           ScreenRect.DefaultWidth, ScreenRect.DefaultHeight)
            {
                // do nothing
            }

            public ScreenRect(int left, int top, int width, int height)
            {
                _left = left;
                _top = top;
                _width = width;
                _height = height;
            }

            [SerializeField]
            private int _width;
            public int Width { get { return _width; } }

            [SerializeField]
            private int _height;
            public int Height { get { return _height; } }

            [SerializeField]
            private int _left;
            public int Left { get { return _left; } }

            [SerializeField]
            private int _top;
            public int Top { get { return _top; } }

            public Vector2Int Resolution { get { return new Vector2Int(_width, _height); } }
            public Vector2Int Position { get { return new Vector2Int(_left, _top); } }
        }
    }
}
