﻿/*
 * Copyright 2019,2020,2021 Sony Corporation
 */

using UnityEngine;

namespace SRD.XR.Utils
{
    /// <summary>
    /// A class for Project Settings of Spatial Reality Display
    /// </summary>
    [SerializeField]
    public class SRDisplayXRProjectSettings : ScriptableObject
    {
        private static SRDisplayXRProjectSettings _instance;
        private SRDisplayXRProjectSettings() { }

        /// <summary>
        /// A flag to run the app with no Spatial Reality Display.
        /// If this is true, the app is able to run with no Spatial Reality Display.
        /// </summary>
        [Tooltip("Check this if you want to run your app with no Spatial Reality Display")]
        public bool RunWithoutSRDisplay;

        internal static SRDisplayXRProjectSettings GetDefault()
        {
            if(_instance != null)
            {
                _instance = null;
            }
            _instance = ScriptableObject.CreateInstance<SRDisplayXRProjectSettings>();
            _instance.RunWithoutSRDisplay = false;
            return _instance;
        }

        /// <summary>
        /// Static function to get SRDisplayXRProjectSettings
        /// </summary>
        /// <returns>SRDisplayXRProjectSettings instance</returns>
        public static SRDisplayXRProjectSettings LoadResourcesOrDefault()
        {
            if(_instance != null)
            {
                return _instance;
            }

            _instance = Resources.Load<SRDisplayXRProjectSettings>("SRDisplayXRProjectSettings");
            if(_instance != null)
            {
                return _instance;
            }

            return SRDisplayXRProjectSettings.GetDefault();
        }

        /// <summary>
        /// Just returns current RunWithoutSRDisplay
        /// </summary>
        /// <returns> A flag that shows RunWithoutSRDisplay is ON or not </returns>
        public static bool IsRunWithoutSRDisplayMode()
        {
            return SRDisplayXRProjectSettings.LoadResourcesOrDefault().RunWithoutSRDisplay;
        }
    }
}
