﻿/*
 * Copyright 2019,2020,2021,2022 Sony Corporation
 */

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace SRD.XR.Utils
{
    internal static class SRDisplayXRMessages
    {
        private enum SRDisplayXRMessageType
        {
            AppCloseMessage,
            DisplayConnectionError, DeviceConnectionError, USB3ConnectionError,
            DeviceNotFoundError, DLLNotFoundError,
            DisplayInterruptionError, DeviceInterruptionError, AppConflictionError,
            FullscreenGameViewError, SRDManagerNotFoundError
        }

        private static Dictionary<SRDisplayXRMessageType, string> SRDisplayXRMessagesDictEn = new Dictionary<SRDisplayXRMessageType, string>()
        {
            {SRDisplayXRMessageType.AppCloseMessage, "The application will be terminated."},
            {SRDisplayXRMessageType.DisplayConnectionError, "Failed to detect SR Display. Make sure HDMI cable is connected correctly between PC and SR Display."},
            {SRDisplayXRMessageType.DeviceConnectionError, "Failed to detect SR Display. Make sure USB 3.0 cable is connected correctly between PC and SR Display."},
            {
                SRDisplayXRMessageType.USB3ConnectionError, string.Join("\n", new string[]{
                    "SR Display is not recognized correctly. Please make sure SR Display and PC's USB 3.0 port are connected with USB3.0 cable. Also, please try following steps.",
                    "    1. Unplug USB cable from PC's USB 3.0 port.",
                    "    2. Turn SR Display's power off.",
                    "    3. Plug USB cable into PC's USB 3.0 port.",
                    "    4. Wait for 30 seconds.",
                    "    5. Turn SR Display's power on.",
                    "    6. Launch this application again.\n",
                })
            },
            // {SRDisplayXRMessageType.DeviceNotFoundError, "Failed to find SR Display device. Make sure SR Display device is powered on."},
            {
                SRDisplayXRMessageType.DeviceNotFoundError, string.Join("\n", new string[]{
                    "Failed to find SR Display device. Please follow the checklist below.",
                    "    1. Make sure SR Display device is powered on.",
                    "    2. Another SR Display application may be already running. Please close it and start this application again.",
                    "    3. Make sure HDMI cable is connected correctly between PC and SR Display.",
                    "    4. Make sure USB 3.0 cable is connected correctly between PC and SR Display.",
                    "    5. SR Display SDK may be not installed correctly. Try to re-install with SRD installer.",
                })
            },
            {SRDisplayXRMessageType.DLLNotFoundError, "SR Display SDK is not found. SR Display SDK may be not installed correctly. Try to re-install with SRD installer."},
            {SRDisplayXRMessageType.DisplayInterruptionError, "HDMI connection has been interrupted."},
            {SRDisplayXRMessageType.DeviceInterruptionError, "USB connection has been interrupted."},
            {SRDisplayXRMessageType.AppConflictionError, "Another SR Display application is already running. Please close it and start this application again."},
            {SRDisplayXRMessageType.FullscreenGameViewError, "Failed to detect SR Display. Make sure HDMI cable is connected correctly between PC and SR Display."},
            {SRDisplayXRMessageType.SRDManagerNotFoundError, "No SRDManager. You must add active SRDManager for SR Display Apps."},
        };

        private static Dictionary<SRDisplayXRMessageType, string> _messageDict;
        private static Dictionary<SRDisplayXRMessageType, string> MessageDict
        {
            get
            {
                if(_messageDict == null)
                {
                    _messageDict = SRDisplayXRMessagesDictEn;
                }
                return _messageDict;
            }
        }


        public static string AppCloseMessage
        {
            get { return MessageDict[SRDisplayXRMessageType.AppCloseMessage]; }
        }
        public static string DisplayConnectionError
        {
            get { return MessageDict[SRDisplayXRMessageType.DisplayConnectionError]; }
        }
        public static string DeviceConnectionError
        {
            get { return MessageDict[SRDisplayXRMessageType.DeviceConnectionError]; }
        }
        public static string USB3ConnectionError
        {
            get { return MessageDict[SRDisplayXRMessageType.USB3ConnectionError]; }
        }
        public static string DeviceNotFoundError
        {
            get { return MessageDict[SRDisplayXRMessageType.DeviceNotFoundError]; }
        }
        public static string DisplayInterruptionError
        {
            get { return MessageDict[SRDisplayXRMessageType.DisplayInterruptionError]; }
        }
        public static string DeviceInterruptionError
        {
            get { return MessageDict[SRDisplayXRMessageType.DeviceInterruptionError]; }
        }
        public static string DLLNotFoundError
        {
            get { return MessageDict[SRDisplayXRMessageType.DLLNotFoundError]; }
        }
        public static string AppConflictionError
        {
            get { return MessageDict[SRDisplayXRMessageType.AppConflictionError]; }
        }

        public static string FullscreenGameView
        {
            get { return MessageDict[SRDisplayXRMessageType.FullscreenGameViewError]; }
        }
        public static string SRDManagerNotFoundError
        {
            get { return MessageDict[SRDisplayXRMessageType.SRDManagerNotFoundError]; }
        }
    }
}
