﻿/*
 * Copyright 2021,2022 Sony Corporation
 */

using System.Collections.Generic;
using UnityEditor;
using UnityEngine;
using UnityEngine.Rendering;
using UnityEngine.XR;
using UnityEngine.XR.Management;

using SRD.XR.Utils;

namespace SRD.XR.Core
{
#if UNITY_EDITOR
    public class SRDisplayXRLoader : XRLoaderHelper, IXRLoaderPreInit
#else
    public class SRDisplayXRLoader : XRLoaderHelper
#endif
    {
        private static List<XRDisplaySubsystemDescriptor> s_DisplaySubsystemDescriptors =
            new List<XRDisplaySubsystemDescriptor>();

        private static List<XRInputSubsystemDescriptor> s_InputSubsystemDescriptors =
            new List<XRInputSubsystemDescriptor>();

        public override bool Initialize()
        {
            Debug.Log("Initialize");
            if(SRDisplayXRProjectSettings.IsRunWithoutSRDisplayMode())
            {

            }
            else 
            {
                CreateSubsystem<XRDisplaySubsystemDescriptor, XRDisplaySubsystem>(s_DisplaySubsystemDescriptors,
                                                                                  "SRDisplayCompositor");
                CreateSubsystem<XRInputSubsystemDescriptor, XRInputSubsystem>(s_InputSubsystemDescriptors,
                                                                              "SRDisplayTracker");

                if((GetLoadedSubsystem<XRDisplaySubsystem>() == null)
                || (GetLoadedSubsystem<XRInputSubsystem>() == null))
                {
                    SRDisplayXrCorePlugin.ShowMessageBox("Confirm", SRDisplayXRMessages.DeviceNotFoundError, Debug.LogWarning);
                    Deinitialize();
                    return false;
                }
            }
            return true;
        }

        public override bool Start()
        {
            // Keep the Splash Screen displayed in 2D
            if(!SplashScreen.isFinished)
            {
                return false;
            }

            Debug.Log("Start");
            StartSubsystem<XRDisplaySubsystem>();
            StartSubsystem<XRInputSubsystem>();
            return true;
        }

        public override bool Stop()
        {
            Debug.Log("Stop");
            StopSubsystem<XRDisplaySubsystem>();
            StopSubsystem<XRInputSubsystem>();
            return true;
        }

        public override bool Deinitialize()
        {
            Debug.Log("Deinitialize");
            DestroySubsystem<XRDisplaySubsystem>();
            DestroySubsystem<XRInputSubsystem>();
            return true;
        }

#if UNITY_EDITOR
        public string GetPreInitLibraryName(BuildTarget buildTarget, BuildTargetGroup buildTargetGroup)
        {
            return "SRDisplayXRNativePlugin";
        }
#endif
    }
}