﻿/*
 * Copyright 2021 Sony Corporation
 */

using UnityEngine;
using UnityEngine.XR.Management;

namespace SRD.XR.Core
{
    [XRConfigurationData("SRDisplayXR", SRDisplayXRBuildSettings.BuildSettingsKey)]
    public class SRDisplayXRBuildSettings : ScriptableObject
    {
        public const string BuildSettingsKey = "srdisplayxr.settings";

        /// <summary>
        /// Stereo rendering mode.
        /// </summary>
        public enum RenderMode
        {
            MultiPass,
            SinglePassInstanced,
        };

        /// <summary>
        /// Stereo rendering mode.
        /// </summary>
        public RenderMode renderMode;

        /// <summary>
        /// Runtime access to build settings.
        /// </summary>
        public static SRDisplayXRBuildSettings Instance
        {
            get
            {
                SRDisplayXRBuildSettings settings = null;
#if UNITY_EDITOR
                UnityEngine.Object obj = null;
                UnityEditor.EditorBuildSettings.TryGetConfigObject(BuildSettingsKey, out obj);
                if(obj == null || !(obj is SRDisplayXRBuildSettings))
                {
                    return null;
                }

                settings = (SRDisplayXRBuildSettings)obj;
#else
                settings = s_RuntimeInstance;
                if(settings == null)
                { settings = new SRDisplayXRBuildSettings(); }
#endif
                return settings;
            }
        }

#if !UNITY_EDITOR
        /// <summary>Static instance that will hold the runtime asset instance we created in our build process.</summary>
        public static SRDisplayXRBuildSettings s_RuntimeInstance = null;

        void OnEnable()
        {
            s_RuntimeInstance = this;
        }
#endif
    }
}