﻿/*
 * Copyright 2021 Sony Corporation
 */

using UnityEditor;
using UnityEngine.UIElements;

using SRD.XR.Core;
using SRD.XR.Utils;

namespace SRD.XR.Editor
{
    internal class SRDisplayXRProjectSettingsAsset
    {
        private const string AssetPath = SRDisplayXRUtils.Constants.SRDProjectSettingsAssetPath;
        private static SRDisplayXRProjectSettings GetOrCreate()
        {
            var settings = AssetDatabase.LoadAssetAtPath<SRDisplayXRProjectSettings>(AssetPath);
            if(settings == null)
            {
                return Create();
            }
            else
            {
                return settings;
            }
        }

        private static SRDisplayXRProjectSettings Create()
        {
            var directoryPath = System.IO.Path.GetDirectoryName(AssetPath);
            System.IO.Directory.CreateDirectory(directoryPath);

            var instance = SRDisplayXRProjectSettings.GetDefault();
            AssetDatabase.CreateAsset(instance, AssetPath);
            AssetDatabase.SaveAssets();
            return instance;
        }

        internal static SerializedObject GetMutable()
        {
            return new SerializedObject(GetOrCreate());
        }

        public static SRDisplayXRProjectSettings Get()
        {
            return GetOrCreate();
        }

        public static bool Exists()
        {
            return System.IO.File.Exists(AssetPath);
        }
    }

    internal class SRDisplayXRProjectSettingsProvider : SettingsProvider
    {
        private SerializedObject mutableSettings;

        public SRDisplayXRProjectSettingsProvider(string path, SettingsScope scope)
            : base(path, scope)
        {
        }

        public override void OnActivate(string searchContext, VisualElement rootElement)
        {
            mutableSettings = SRDisplayXRProjectSettingsAsset.GetMutable();
        }

        public override void OnGUI(string searchContext)
        {
            EditorGUILayout.PropertyField(mutableSettings.FindProperty("RunWithoutSRDisplay"));
            mutableSettings.ApplyModifiedProperties();
        }
    }

    static class SRDisplayXRProjectSettingsRegister
    {
     /* [SettingsProvider] */
        private static SettingsProvider CreateProviderToRegister()
        {
            var path = "Project/Spatial Reality Display";
            var provider = new SRDisplayXRProjectSettingsProvider(path, SettingsScope.Project);
            return provider;
        }
    }
}
