﻿/*
 * Copyright 2021 Sony Corporation
 */

#if XR_MGMT_OVER_320

using System.Collections.Generic;
using UnityEditor;
using UnityEditor.XR.Management.Metadata;
using UnityEngine;

using SRD.XR.Core;

namespace SRD.XR.Editor
{
    internal class SRDisplayXRMetadata : IXRPackage
    {
        private class SRDisplayXRPackageMetadata : IXRPackageMetadata
        {
            public string packageName => "SRDisplay XR Unity Plugin";
            public string packageId => "com.sony.xr.srdisplay";
            public string settingsType => "SRD.XR.Core.SRDisplayXRBuildSettings";

            private static readonly List<IXRLoaderMetadata> s_LoaderMetadata = new List<IXRLoaderMetadata>() { new SRDisplayXRLoaderMetadata() };
            public List<IXRLoaderMetadata> loaderMetadata => s_LoaderMetadata;
        }

        private class SRDisplayXRLoaderMetadata : IXRLoaderMetadata
        {
            public string loaderName => "SRDisplay XR Loader";
            public string loaderType => "SRD.XR.Core.SRDisplayXRLoader";

            private static readonly List<BuildTargetGroup> s_SupportedBuildTargets = new List<BuildTargetGroup>()
            {
                BuildTargetGroup.Standalone,
            };
            public List<BuildTargetGroup> supportedBuildTargets => s_SupportedBuildTargets;
        }

        private static IXRPackageMetadata s_Metadata = new SRDisplayXRPackageMetadata();
        public IXRPackageMetadata metadata => s_Metadata;

        public bool PopulateNewSettingsInstance(ScriptableObject obj)
        {
            var settings = obj as SRDisplayXRBuildSettings;
            if(settings != null)
            {
                settings.renderMode = SRDisplayXRBuildSettings.RenderMode.SinglePassInstanced;
                return true;
            }

            return false;
        }
    }
}

#endif