/*
 * Copyright 2019,2020 Sony Corporation
 */

using System;
using System.IO;
using System.Diagnostics;

namespace UnrealBuildTool.Rules
{
	public class SRDisplayModule : ModuleRules
	{
		public SRDisplayModule(ReadOnlyTargetRules Target) : base(Target)
		{
			BuildVersion Version;
			if (!BuildVersion.TryRead(BuildVersion.GetDefaultFileName(), out Version))
			{
				Version = new BuildVersion();
			}

			PrivateIncludePaths.AddRange(
				new string[] {
				}
				);

			PublicDependencyModuleNames.AddRange(
				new string[]
				{
					"Core",
					"Engine",
					"UMG",
				}
				);

			PrivateDependencyModuleNames.AddRange(
				new string[]
				{
					"CoreUObject",
					"Slate",
					"SlateCore",
					"HeadMountedDisplay",
					"RHI",
					"Renderer",
					"RenderCore",
					"Projects",
					"ApplicationCore",
					"ImageWrapper",
					"InputCore",
				}
				);

			if (Target.bBuildEditor == true)
			{
				PrivateDependencyModuleNames.Add("UnrealEd");
			}

			DynamicallyLoadedModuleNames.AddRange(
				new string[]
				{
					// ... add any modules that your module loads dynamically here ...
				}
				);

			String XrRuntimeRoot = Path.GetFullPath(Path.Combine(ModuleDirectory, "External/xr-runtime/"));
			PublicIncludePaths.Add(Path.Combine(XrRuntimeRoot, "include"));

			if (Target.Platform == UnrealTargetPlatform.Win64)
			{
				bUseRTTI = true;
				string XrRuntimeLibPath = Path.Combine(XrRuntimeRoot, "lib");

				PublicSystemLibraryPaths.Add(XrRuntimeLibPath);
				PublicAdditionalLibraries.Add(Path.Combine(XrRuntimeLibPath, "xr_api.lib"));
			}
		}
	}
}
