/**
 * Copyright 2019,2020,2021 Sony Corporation
 */
 
#ifndef XR_API_H_
#define XR_API_H_

#include "xr_build.h"
#include "xr_api_defs.h"

// = Standard Library =============================
#include <vector>

XR_DEFINE_HANDLE(SrdXrSessionHandle);

namespace srd {
    namespace xr {
        SRD_XR_API SrdXrResult srd_xrCreateSession(const SrdXrSessionCreateInfo* create_info, SrdXrSessionHandle* session);
        SRD_XR_API SrdXrResult srd_xrDestroySession(SrdXrSessionHandle* session);
        SRD_XR_API SrdXrResult srd_xrBeginSession(SrdXrSessionHandle session, const SrdXrSessionBeginInfo* begin_info);
        SRD_XR_API SrdXrResult srd_xrEndSession(SrdXrSessionHandle session);
        SRD_XR_API SrdXrResult srd_xrPollEvent(SrdXrSessionHandle session, SrdXrEventDataBuffer* event_data);
        SRD_XR_API SrdXrResult srd_xrBeginFrame(SrdXrSessionHandle session);
        SRD_XR_API SrdXrResult srd_xrEndFrame(SrdXrSessionHandle session, const SrdXrFrameEndInfo* frame_end_info);
        SRD_XR_API SrdXrResult srd_xrLocateViews(SrdXrSessionHandle session, const SrdXrViewLocateInfo* view_locate_info, SrdXrView* views);

        /* extension API */
        SRD_XR_API SrdXrResult srd_xr_extGetPlatformSpecificData(SrdXrSessionHandle session, SrdXrPlatformSpecificData* data);
        SRD_XR_API SrdXrResult srd_xr_extGetProjectionMatrix(SrdXrSessionHandle session, const SrdXrProjectionMatrixInfo* projection_matrix_info, SrdXrProjectionMatrix* projection_matrix);
        SRD_XR_API SrdXrResult srd_xr_extSetGraphicsAPI(SrdXrSessionHandle session, SrdXrGraphicsAPI graphics_api);
        SRD_XR_API SrdXrResult srd_xr_extSetRenderDevice(SrdXrSessionHandle session, void* device_ptr);
        SRD_XR_API SrdXrResult srd_xr_extGenerateTextureAndShaders(SrdXrSessionHandle session, SrdXrTexture* left_texture, SrdXrTexture* right_texture, SrdXrTexture* render_target);

        SRD_XR_API SrdXrResult srd_xr_extEnumerateDevices(std::vector<SrdXrDeviceInfo>* display_list);
        SRD_XR_API SrdXrResult srd_xr_extGetDevice(unsigned int device_index, SrdXrDeviceInfo* display);
        SRD_XR_API SrdXrResult srd_xr_extGetDeviceState(SrdXrSessionHandle session, SrdXrDeviceState* device_state);

        SRD_XR_API SrdXrResult srd_xr_extLocateDisplay(SrdXrSessionHandle session, const SrdXrDisplayLocateInfo* display_locate_info, SrdXrDisplay* display);

        SRD_XR_API SrdXrResult srd_xr_extSetDebugLogCallback(SrdXrLogCallback callback);

        SRD_XR_API SrdXrResult srd_xr_extGetCrosstalkCorrectionSettings(SrdXrSessionHandle session, SrdXrCrosstalkCorrectionSettings* settings);
        SRD_XR_API SrdXrResult srd_xr_extSetCrosstalkCorrectionSettings(SrdXrSessionHandle session, const SrdXrCrosstalkCorrectionSettings* settings);
        SRD_XR_API SrdXrResult srd_xr_extGetCrosstalkCorrectionSettings_v1_1_0(SrdXrSessionHandle session, SrdXrCrosstalkCorrectionSettings_v1_1_0* settings);
        SRD_XR_API SrdXrResult srd_xr_extSetCrosstalkCorrectionSettings_v1_1_0(SrdXrSessionHandle session, const SrdXrCrosstalkCorrectionSettings_v1_1_0* settings);
        SRD_XR_API SrdXrResult srd_xr_extGetCrosstalkCorrectionSystemSettings(SrdXrSessionHandle session, SrdXrCrosstalkCorrectionSystemSettings* settings);
        SRD_XR_API SrdXrResult srd_xr_extSetCrosstalkCorrectionSystemSettings(SrdXrSessionHandle session, const SrdXrCrosstalkCorrectionSystemSettings* settings);
        SRD_XR_API SrdXrResult srd_xr_extSetColorManagementSettings(SrdXrSessionHandle session, const SrdXrColorManagementSettings* settings);
        SRD_XR_API SrdXrResult srd_xr_extEnableTemperatureCompensation(SrdXrSessionHandle session, bool enable);

        SRD_XR_API SrdXrResult srd_xr_extSaveUserSettings(SrdXrSessionHandle session);
        SRD_XR_API SrdXrResult srd_xr_extGetCameraSettings(SrdXrSessionHandle session, SrdXrCameraSettings* camera_settings);
        SRD_XR_API SrdXrResult srd_xr_extSetCameraSettings(SrdXrSessionHandle session, const SrdXrCameraSettings* camera_settings);
        SRD_XR_API SrdXrResult srd_xr_extGetCameraGain(SrdXrSessionHandle session, float* gain);
        SRD_XR_API SrdXrResult srd_xr_extSetCameraGain(SrdXrSessionHandle session, const float gain);
        SRD_XR_API SrdXrResult srd_xr_extShowCapturedImageWindow(SrdXrSessionHandle session, bool show_flag);
        SRD_XR_API SrdXrResult srd_xr_extGetPerformanceMode(SrdXrSessionHandle session, SrdXrPerformanceMode* performance_mode);
        SRD_XR_API SrdXrResult srd_xr_extSetPerformanceMode(SrdXrSessionHandle session, const SrdXrPerformanceMode performance_mode);

        /* Debug API */
        SRD_XR_API SrdXrResult srd_xr_debugGetFloatWithQuery(SrdXrSessionHandle session, const char* query, float* data);
        SRD_XR_API SrdXrResult srd_xr_debugSetFloatWithQuery(SrdXrSessionHandle session, const char* query, float data);
        SRD_XR_API SrdXrResult srd_xr_debugGetIntWithQuery(SrdXrSessionHandle session, const char* query, int* data);
        SRD_XR_API SrdXrResult srd_xr_debugSetIntWithQuery(SrdXrSessionHandle session, const char* query, int data);
        SRD_XR_API SrdXrResult srd_xr_debugGetStringWithQuery(SrdXrSessionHandle session, const char* query, char** data);
        SRD_XR_API SrdXrResult srd_xr_debugSetStringWithQuery(SrdXrSessionHandle session, const char* query, const char* data);
        SRD_XR_API SrdXrResult srd_xr_debugGetViewpointCompositorParams(SrdXrSessionHandle session, SrdXrViewpointCompositorParams* params);
        SRD_XR_API SrdXrResult srd_xr_debugSetViewpointCompositorParams(SrdXrSessionHandle session, const SrdXrViewpointCompositorParams* params);

    } // namespace xr
} // namespace srd

#endif // XR_API_H_
