﻿/**
 * Copyright 2019,2020,2021 Sony Corporation
 */

#ifndef XR_API_WRAPPER_H_
#define XR_API_WRAPPER_H_

#include "xr_api_defs.h"

// = Standard Library =============================
#include <vector>

XR_DEFINE_HANDLE(SrdXrSessionHandle);

namespace srd {
    namespace xr {

        SrdXrResult CreateSession(const SrdXrSessionCreateInfo* create_info, SrdXrSessionHandle* session);

        SrdXrResult DestroySession(SrdXrSessionHandle* session);

        SrdXrResult BeginSession(SrdXrSessionHandle session, const SrdXrSessionBeginInfo* begin_info);

        SrdXrResult EndSession(SrdXrSessionHandle session);

        SrdXrResult PollEvent(SrdXrSessionHandle session, SrdXrEventDataBuffer* event_data);

        SrdXrResult BeginFrame(SrdXrSessionHandle session);

        SrdXrResult EndFrame(SrdXrSessionHandle session, const SrdXrFrameEndInfo* frame_end_info);

        SrdXrResult LocateViews(SrdXrSessionHandle session, const SrdXrViewLocateInfo* view_locate_info, SrdXrView* views);

        namespace ext {

            SrdXrResult GetPlatformSpecificData(SrdXrSessionHandle session, SrdXrPlatformSpecificData* data);

            SrdXrResult GetProjectionMatrix(SrdXrSessionHandle session, const SrdXrProjectionMatrixInfo* projection_matrix_info, SrdXrProjectionMatrix* projection_matrix);

            SrdXrResult SetGraphicsAPI(SrdXrSessionHandle session, SrdXrGraphicsAPI graphics_api);

            SrdXrResult SetRenderDevice(SrdXrSessionHandle session, void* device_ptr);

            SrdXrResult GenerateTextureAndShaders(SrdXrSessionHandle session, SrdXrTexture* left_texture, SrdXrTexture* right_texture, SrdXrTexture* render_target);

            SrdXrResult EnumerateDevices(std::vector<SrdXrDeviceInfo>* display_list);

            SrdXrResult GetDevice(unsigned int device_index, SrdXrDeviceInfo* display);

            SrdXrResult GetDeviceState(SrdXrSessionHandle session, SrdXrDeviceState* device_state);

            SrdXrResult LocateDisplay(SrdXrSessionHandle session, const SrdXrDisplayLocateInfo* display_locate_info, SrdXrDisplay* display);

            SrdXrResult SetDebugLogCallback(SrdXrLogCallback callback);

            SrdXrResult GetCrosstalkCorrectionSettings(SrdXrSessionHandle session, SrdXrCrosstalkCorrectionSettings* settings);

            SrdXrResult SetCrosstalkCorrectionSettings(SrdXrSessionHandle session, const SrdXrCrosstalkCorrectionSettings* settings);

            SrdXrResult GetCrosstalkCorrectionSettings_v1_1_0(SrdXrSessionHandle session, SrdXrCrosstalkCorrectionSettings_v1_1_0* settings);

            SrdXrResult SetCrosstalkCorrectionSettings_v1_1_0(SrdXrSessionHandle session, const SrdXrCrosstalkCorrectionSettings_v1_1_0* settings);

            SrdXrResult GetCrosstalkCorrectionSystemSettings(SrdXrSessionHandle session, SrdXrCrosstalkCorrectionSystemSettings* settings);

            SrdXrResult SetCrosstalkCorrectionSystemSettings(SrdXrSessionHandle session, const SrdXrCrosstalkCorrectionSystemSettings* settings);

            SrdXrResult SetColorManagementSettings(SrdXrSessionHandle session, const SrdXrColorManagementSettings* settings);

            SrdXrResult EnableTemperatureCompensation(SrdXrSessionHandle session, bool enable);

            SrdXrResult SaveUserSettings(SrdXrSessionHandle session);

            SrdXrResult GetCameraSettings(SrdXrSessionHandle session, SrdXrCameraSettings* camera_settings);

            SrdXrResult SetCameraSettings(SrdXrSessionHandle session, const SrdXrCameraSettings* camera_settings);

            SrdXrResult GetCameraGain(SrdXrSessionHandle session, float* gain);

            SrdXrResult SetCameraGain(SrdXrSessionHandle session, const float gain);

            SrdXrResult ShowCapturedImageWindow(SrdXrSessionHandle session, bool show_flag);

            SrdXrResult GetPerformanceMode(SrdXrSessionHandle session, SrdXrPerformanceMode* performance_mode);

            SrdXrResult SetPerformanceMode(SrdXrSessionHandle session, const SrdXrPerformanceMode performance_mode);

            SrdXrResult PauseHeadTracking(SrdXrSessionHandle session);

            SrdXrResult ResumeHeadTracking(SrdXrSessionHandle session);

        } // namespace ext

        namespace debug {
            SrdXrResult GetFloatWithQuery(SrdXrSessionHandle session, const char* query, float* data);

            SrdXrResult SetFloatWithQuery(SrdXrSessionHandle session, const char* query, float data);

            SrdXrResult GetIntWithQuery(SrdXrSessionHandle session, const char* query, int* data);

            SrdXrResult SetIntWithQuery(SrdXrSessionHandle session, const char* query, int data);

            SrdXrResult GetStringWithQuery(SrdXrSessionHandle session, const char* query, char** data);

            SrdXrResult SetStringWithQuery(SrdXrSessionHandle session, const char* query, const char* data);

            SrdXrResult GetViewpointCompositorParams(SrdXrSessionHandle session, SrdXrViewpointCompositorParams* params);

            SrdXrResult SetViewpointCompositorParams(SrdXrSessionHandle session, const SrdXrViewpointCompositorParams* params);
        } // namespace debug

    } // namspace xr
} // namespace srd

#endif // XR_API_WRAPPER_H_
