/*
 * Copyright 2019,2020 Sony Corporation
 */

#include "ISRDisplayModule.h"
#include "SRDisplaySystem.h"

#include <SceneViewExtension.h>
#include <Interfaces/IPluginManager.h>

//-------------------------------------------------------------------------------------------------
// FSRDisplayModule
//-------------------------------------------------------------------------------------------------

namespace sr_display
{
	class FSRDisplayModule : public ISRDisplayModule
	{
		/** IHeadMountedDisplayModule implementation */
		virtual TSharedPtr< class IXRTrackingSystem, ESPMode::ThreadSafe > CreateTrackingSystem() override;

		virtual void StartupModule() override
		{
			IHeadMountedDisplayModule::StartupModule();
			// This code will execute after your module is loaded into memory (but after global variables are initialized, of course.)

			// Register shader pass to engine
			FString PluginShaderDir = FPaths::Combine(IPluginManager::Get().FindPlugin(TEXT("SRDisplayPlugin"))->GetBaseDir(), TEXT("Shaders"));
			AddShaderSourceDirectoryMapping(TEXT("/Plugin/SRDisplayPlugin"), PluginShaderDir);
		}

		virtual void ShutdownModule() override
		{
			// This function may be called during shutdown to clean up your module.  For modules that support dynamic reloading,
			// we call this function before unloading the module.
		}

		virtual FString GetModuleKeyName() const override
		{
			return FString(TEXT("SRDisplayModule"));
		}

	};

	TSharedPtr< class IXRTrackingSystem, ESPMode::ThreadSafe > FSRDisplayModule::CreateTrackingSystem()
	{
		TSharedRef<sr_display::FSRDisplaySystem, ESPMode::ThreadSafe> ARHeadMountedDisplay = FSceneViewExtensions::NewExtension<sr_display::FSRDisplaySystem>();
		if (ARHeadMountedDisplay->IsInitialized())
		{
			return ARHeadMountedDisplay;
		}
		return nullptr;
	}

} // namespace sr_display

IMPLEMENT_MODULE(sr_display::FSRDisplayModule, SRDisplayModule)
