/*
 * Copyright 2019,2020 Sony Corporation
 */

#pragma once

// <-- Engine Header -->
#include <Engine.h>
#include <CoreMinimal.h>
#include <Widgets/SWindow.h>

class UTextureRenderTarget2D;
class FRHICommandListImmediate;

namespace sr_display
{
	class SSRDisplaySceneViewport;

	class FSRDisplayWindow
	{
	public:

		static void Initialize(FVector2D Resolution, FIntRect ScreenPosition);
		static void Finalize();
		static FSRDisplayWindow* GetPlayWindow();

	public:

		FSRDisplayWindow(FVector2D Resolution);
		~FSRDisplayWindow();

		TSharedPtr<SWindow> GetWindow();
		UTextureRenderTarget2D* GetRenderTarget();

		void RenderTexture_RenderThread(FRHICommandListImmediate& RHICmdList);

		bool GetMousePosition(FVector2D& MousePosition) const;

		FViewport* GetViewport();

	private:

		void OnWindowClosed(const TSharedRef<SWindow>& InWindow);

	private:

		static TSharedPtr<FSRDisplayWindow> PlayWindow;

		TSharedPtr<SWindow> Window;
		FOnWindowClosed InDelegate;
		TSharedPtr<SSRDisplaySceneViewport> PlaySceneViewport;
	};

} // namespace sr_display
