/*
 * Copyright 2019,2020 Sony Corporation
 */

#pragma once

// <-- Engine Header -->
#include <CoreMinimal.h>
#include <Widgets/SCompoundWidget.h>
#include <Widgets/DeclarativeSyntaxSupport.h>

class SViewport;
class FSceneViewport;
class UTextureRenderTarget2D;
class FRHICommandListImmediate;

namespace sr_display
{
	class FSRDisplayViewportClient;

	class SSRDisplaySceneViewport : public SCompoundWidget
	{
	public:

		SLATE_BEGIN_ARGS(SSRDisplaySceneViewport) { }
		SLATE_END_ARGS()

	public:

		void Construct(const FArguments& InArgs);

		void Init(float SizeX, float SizeY);

		void Shutdown();

		virtual void Tick(const FGeometry& AllottedGeometry, const double InCurrentTime, const float InDeltaTime) override;

		UTextureRenderTarget2D* GetRenderTarget();

		void RenderTexture_RenderThread(FRHICommandListImmediate& RHICmdList);

		bool GetMousePosition(FVector2D& MousePosition) const;

		FViewport* GetViewport();

	private:

		TSharedPtr<SViewport> Viewport;
		TSharedPtr<FSceneViewport> SceneViewport;
		TSharedPtr<FSRDisplayViewportClient> PlayViewportClient;
	};

} // namespace sr_display
