/*
 * Copyright 2019,2020 Sony Corporation
 */

#pragma once

#include <string>

namespace sr_display
{
	const std::wstring SRD_ERROR_MESSAGE_C016 =
		L"Unknown error has occurred.";
	const std::wstring SRD_ERROR_MESSAGE_C017 =
		L"This application will be terminated when \"OK\" button pressed.";
	const std::wstring SRD_ERROR_MESSAGE_C018 =
		L"No SR Display is connected. Make sure HDMI cable is connected between PC and SR Display.";
	const std::wstring SRD_ERROR_MESSAGE_C019 =
		L"No SR Display is connected. Make sure USB3.0 cable is connected between PC and SR Display.";
	const std::wstring SRD_ERROR_MESSAGE_C020 =
		L"No SR Display is connected. Make sure SR Display's power is turned on.";
	const std::wstring SRD_ERROR_MESSAGE_C021 =
		L"SR Display connection has been lost. The USB cable may be disconnected or SR Display's power may be turned off.";
	const std::wstring SRD_ERROR_MESSAGE_C022 =
		L"SR Display SDK was not found. SDK may be not installed yet. Please install SDK before using SR Display applications.";
	const std::wstring SRD_ERROR_MESSAGE_C023 =
		L"There is an application already using SR Display. Only one application can be used with SR Display at a time.";
	const std::wstring SRD_ERROR_MESSAGE_C030 =
		L"SR Display is not recognized correctly. "
		L"Please make sure SR Display and PC's USB 3.0 port are connected with USB3.0 cable. "
		L"Also, please try following steps.\n"
		L"\n"
		L"    1. Unplug USB cable from PC's USB 3.0 port.\n"
		L"    2. Turn SR Display's power off.\n"
		L"    3. Plug USB cable into PC's USB 3.0 port.\n"
		L"    4. Wait for 30 seconds.\n"
		L"    5. Turn SR Display's power on.\n"
		L"    6. Launch this application again.\n";

	const std::wstring SRD_ERROR_MESSAGE_UE022 =
		L"SR Display Plugin does not support \"Mobile Preview ES3.1 (PIE)\".";
	const std::wstring SRD_ERROR_MESSAGE_UE023 =
		L"SR Display Plugin does not support graphics API other than D3D11. This project is using unsupported graphics API.";

} // namespace sr_display
