/*
 * Copyright 2019,2020 Sony Corporation
 */

#pragma once

#include <Rendering/SlateRenderer.h>

namespace sr_display
{
	class FStereoTexture
	{
	public:

		FStereoTexture();
		~FStereoTexture();
		void SetLeft(FTexture2DRHIRef Left);
		void SetRight(FTexture2DRHIRef Right);
		void Overwrite(FTexture2DRHIRef Left, FTexture2DRHIRef Right,
			FRHICommandListImmediate& RHICmdList, uint32 SourceWidth, uint32 SourceHeight) const;

		bool IsValid() const;

	private:
		FTexture2DRHIRef LeftTexture;
		FTexture2DRHIRef RightTexture;
	};

} // namespace sr_display
