/*
 * Copyright 2019,2020 Sony Corporation
 */

#pragma once

#include <Engine.h>

namespace sr_display
{
	class FDisplayProjector
	{
	public:

		FDisplayProjector(FVector4& LeftBottomPosition, FVector4& LeftTopPosition, FVector4& RightBottomPosition, FVector4& RightTopPosition);
		~FDisplayProjector();

		void SetDisplayCornersPosition(FVector4& LeftBottomPosition, FVector4& LeftTopPosition, FVector4& RightBottomPosition, FVector4& RightTopPosition);
		bool ExecuteDisplayProjection(FRHICommandListImmediate& RHICmdList, EStereoscopicPass StereoPass, FRHITexture2D* BackBuffer, FRHITexture2D* SrcTexture, FVector2D WindowSize, FMatrix ViewProjectionMatrix, uint32 SourceWidth, uint32 SourceHeight) const;

	private:
		// Convert world position to screen position [range: 0.0 ~ 1.0]
		void ConvertWorldPositionToScreen(const FVector4& WorldPosition, const FMatrix& ViewProjectionMatrix, FVector2D& OutScreenPosition) const;

		void CalculateHomographyMatrix(FVector2D InLeftBottomPosition, FVector2D InLeftTopPosition, FVector2D InRightBottomPosition, FVector2D InRightTopPosition, FMatrix& OutMatrix) const;

	private:
		IRendererModule* RendererModule = nullptr;

		FVector4 LeftBottomCornerPosition;
		FVector4 LeftTopCornerPosition;
		FVector4 RightBottomCornerPosition;
		FVector4 RightTopCornerPosition;
	};

} // namespace sr_display
