/*
 * Copyright 2019,2020 Sony Corporation
 */

#include "Blueprint/SRDisplayManager.h"
#include "Blueprint/SRDisplayDrawBoxComponent.h"

ASRDisplayManager::ASRDisplayManager()
{
	Box = CreateDefaultSubobject<USRDisplayDrawBoxComponent>(TEXT("Box"));
}

float ASRDisplayManager::GetRealToVirtualScale()
{
	float RealToVirtualScale = 1.f;
	if (Box)
	{
		RealToVirtualScale = Box->GetComponentScale().X; // X, Y and Z is always same value.
	}
	return RealToVirtualScale;
}

#if WITH_EDITOR
void ASRDisplayManager::PostEditChangeProperty(struct FPropertyChangedEvent& e)
{
	FName PropertyName = (e.Property != NULL) ? e.Property->GetFName() : NAME_None;
	FName MemberPropertyName = (e.Property != NULL) ? e.MemberProperty->GetFName() : NAME_None;

	if (MemberPropertyName == "RelativeScale3D")
	{
		FVector Current = Box->GetComponentScale();
		float scaling = 1.f;
		if (PropertyName == "X")
		{
			scaling = Current.X;
		}
		else if (PropertyName == "Y")
		{
			scaling = Current.Y;
		}
		else if (PropertyName == "Z")
		{
			scaling = Current.Z;
		}
		else if (PropertyName == "RelativeScale3D")
		{
			scaling = Current.X;
		}

		Box->SetWorldScale3D(FVector(scaling, scaling, scaling));
		LineThickness = scaling == 0.f ? 1.f : roundf(scaling / 10);
	}

	Box->BoxColor = BoxColor;
	Box->DisplayColor = DisplayColor;
	Box->LineThickness = LineThickness;

	Super::PostEditChangeProperty(e);
}

#endif
