/*
 * Copyright 2019,2020 Sony Corporation
 */

#include "Blueprint/SRDisplayFunctionLibrary.h"
#include "SRDisplaySystem.h"

USRDisplayFunctionLibrary::USRDisplayFunctionLibrary(const FObjectInitializer& ObjectInitializer)
	: Super(ObjectInitializer)
{
}

void USRDisplayFunctionLibrary::SetStereoImages(UTexture2D* LeftImage, UTexture2D* RightImage)
{
#if PLATFORM_WINDOWS
	sr_display::FSRDisplaySystem* SRDisplaySystem = dynamic_cast<sr_display::FSRDisplaySystem*>(GEngine->XRSystem.Get());
	if (SRDisplaySystem && LeftImage && RightImage)
	{
		SRDisplaySystem->SetStereoImages(
			LeftImage->Resource->TextureRHI->GetTexture2D(),
			RightImage->Resource->TextureRHI->GetTexture2D());
	}
#endif // PLATFORM_WINDOWS
}

void USRDisplayFunctionLibrary::ShowStereoImages(bool bShow)
{
#if PLATFORM_WINDOWS
	sr_display::FSRDisplaySystem* SRDisplaySystem = dynamic_cast<sr_display::FSRDisplaySystem*>(GEngine->XRSystem.Get());
	if (SRDisplaySystem)
	{
		SRDisplaySystem->ShowStereoImages(bShow);
	}
#endif // PLATFORM_WINDOWS
}

bool USRDisplayFunctionLibrary::IsStereoImagesShown()
{
#if PLATFORM_WINDOWS
	sr_display::FSRDisplaySystem* SRDisplaySystem = dynamic_cast<sr_display::FSRDisplaySystem*>(GEngine->XRSystem.Get());
	if (SRDisplaySystem)
	{
		return SRDisplaySystem->IsStereoImagesShown();
	}
#endif // PLATFORM_WINDOWS
	return false;
}

bool USRDisplayFunctionLibrary::GetMousePosition(float& LocationX, float& LocationY)
{
#if PLATFORM_WINDOWS
	sr_display::FSRDisplaySystem* SRDisplaySystem = dynamic_cast<sr_display::FSRDisplaySystem*>(GEngine->XRSystem.Get());
	if (SRDisplaySystem)
	{
		return SRDisplaySystem->GetMousePosition(LocationX, LocationY);
	}
#endif // PLATFORM_WINDOWS

	LocationX = 0.f;
	LocationY = 0.f;
	return false;
}

bool USRDisplayFunctionLibrary::DeprojectScreenToWorld(APlayerController const* Player, const FVector2D& ScreenPosition, FVector& WorldPosition, FVector& WorldDirection, FVector& CameraPosition)
{
#if PLATFORM_WINDOWS
	sr_display::FSRDisplaySystem* SRDisplaySystem = dynamic_cast<sr_display::FSRDisplaySystem*>(GEngine->XRSystem.Get());
	if (SRDisplaySystem)
	{
		return SRDisplaySystem->DeprojectScreenToWorld(Player, ScreenPosition, WorldPosition, WorldDirection, CameraPosition);
	}
#endif // PLATFORM_WINDOWS

	// something went wrong, zero things and return false
	WorldPosition = FVector::ZeroVector;
	WorldDirection = FVector::ZeroVector;
	return false;
}

bool USRDisplayFunctionLibrary::ConvertMouseLocationToWorldSpace(APlayerController const* Player, FVector& WorldPosition, FVector& WorldDirection, FVector& CameraPosition)
{
#if PLATFORM_WINDOWS
	sr_display::FSRDisplaySystem* SRDisplaySystem = dynamic_cast<sr_display::FSRDisplaySystem*>(GEngine->XRSystem.Get());
	if (SRDisplaySystem)
	{
		float LocationX = 0.f;
		float LocationY = 0.f;
		if (SRDisplaySystem->GetMousePosition(LocationX, LocationY))
		{
			FVector2D ScreenPosition(LocationX, LocationY);
			return SRDisplaySystem->DeprojectScreenToWorld(Player, ScreenPosition, WorldPosition, WorldDirection, CameraPosition);
		}
	}
#endif // PLATFORM_WINDOWS

	// something went wrong, zero things and return false
	WorldPosition = FVector::ZeroVector;
	WorldDirection = FVector::ZeroVector;
	return false;
}
