/**
 * Copyright 2019,2020 Sony Corporation
 */

#ifndef SRD_XR_API_DEFS_H_
#define SRD_XR_API_DEFS_H_

#include "xr_api_defs.h"

const float kDefaultDisplayWidth_m = 0.3442176f;
const float kDefaultDisplayHeight_m = 0.1936224f;
const float kDefaultDisplayTilt_rad = 0.785398f; // = 45f * deg2rad
const uint32_t kDefaultHorizontalResolution_px = 3840;
const uint32_t kDefaultVerticalResolution_px = 2160;

struct SrdXrSrdData : public SrdXrPlatformSpecificData {
    SrdXrDisplaySize display_size;
    float display_tilt_rad;
    SrdXrDisplayResolution display_resolution;

    SrdXrSrdData()
        : display_size(kDefaultDisplayWidth_m, kDefaultDisplayHeight_m),
          display_tilt_rad(kDefaultDisplayTilt_rad),
          display_resolution(kDefaultHorizontalResolution_px, kDefaultVerticalResolution_px) {}
    SrdXrSrdData(SrdXrDisplaySize in_display_size, float in_display_tilt,
                 SrdXrDisplayResolution in_display_resolution)
        : display_size(in_display_size), display_tilt_rad(in_display_tilt),
          display_resolution(in_display_resolution) {}
};

#endif // SRD_XR_API_DEFS_H_
