/*
 * Copyright 2019,2020 Sony Corporation
 */

#pragma once

#include <CoreMinimal.h>
#include <Components/PrimitiveComponent.h>

#include "SRDisplayDrawBoxComponent.generated.h"

class FPrimitiveSceneProxy;

UCLASS(collapsecategories, hidecategories = Object, editinlinenew, MinimalAPI)
class USRDisplayDrawBoxComponent : public UPrimitiveComponent
{
	GENERATED_UCLASS_BODY()

	UPROPERTY(EditAnywhere, Category = DrawBoxComponent)
	FColor BoxColor;

	UPROPERTY(EditAnywhere, Category = DrawBoxComponent)
	FColor DisplayColor;

	UPROPERTY(EditAnywhere, Category = DrawBoxComponent)
	float LineThickness;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = DrawBoxComponent)
	float TargetScale;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = DrawBoxComponent)
	mutable float DisplayWidth;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = DrawBoxComponent)
	mutable float DisplayHeight;

	mutable float DisplayTilt;

	//~ Begin UPrimitiveComponent Interface.
	virtual FPrimitiveSceneProxy* CreateSceneProxy() override;
	virtual FBoxSphereBounds CalcBounds(const FTransform& LocalToWorld) const override;
	//~ End UPrimitiveComponent Interface.
};
