// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Components/ActorComponent.h"
#include "InputManagerComponent.generated.h"

DECLARE_LOG_CATEGORY_EXTERN(LogInputManagerComponent, Log, All);


struct DeviceId
{
	int32 VendorID;
	int32 ProductID;
};


DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FInputDeviceAttachedHandler, bool, IsAttached);


UCLASS( ClassGroup=(Custom), meta=(BlueprintSpawnableComponent) )
class CADBIMVIEWER_API UInputManagerComponent : public UActorComponent
{
	GENERATED_BODY()

	int32 DeviceHandle = INDEX_NONE;
	TArray<DeviceId> DeviceIdList;
	bool IsRawInputDeviceAttached = false;
	bool IsBuiltInDeviceAttached = false;
	bool LastDeviceAttached = false;

public:	
	// Sets default values for this component's properties
	UInputManagerComponent();

protected:
	// Called when the game starts
	virtual void BeginPlay() override;

	virtual void BeginDestroy() override;

public:	
	// Called every frame
	virtual void TickComponent(float DeltaTime, ELevelTick TickType, FActorComponentTickFunction* ThisTickFunction) override;

	/**
	 * Callback for handling an input device's connection state change.
	 */
	void OnInputDeviceConnectionChange(EInputDeviceConnectionState NewConnectionState, FPlatformUserId PlatformUserId, FInputDeviceId InputDeviceId);

	/**
     * Event triggered at input devices attached state changed.
	 */
	UPROPERTY(BlueprintAssignable, DisplayName = OnInputDeviceAttachedHandler)
	FInputDeviceAttachedHandler OnInputDeviceAttachedHandler;

	/**
	 * @return True if an XInput Gamepad or a configured RawInput device is attached.
	 */
	UFUNCTION(BlueprintCallable)
	bool IsDeviceAttached() const { return IsRawInputDeviceAttached || IsBuiltInDeviceAttached; }

private:
	/* Initialize for RawInput */
	void RegisterDevice();

	/* Check for the existing configured device in connected RawInput devices */
	void UpdateRawInputDeviceAttached();
};
