#include "CADBIMViewerBPFuncLib.h"

#include <Windows.h>

class MoveDialogTask : public FNonAbandonableTask
{
	friend class FAutoDeleteAsyncTask<MoveDialogTask>;

public:
	MoveDialogTask() {};

	void DoWork() {
		int retry = 10;
		HWND hWnd = NULL;
		while (retry) {
			hWnd = FindWindow(L"#32770", L"Choose A File");
			if (hWnd != NULL) break;
			FPlatformProcess::Sleep(0.02f);
			retry--;
		}

		if (hWnd == NULL) return;

		for (size_t i = 0; i < 10;)
		{
			FPlatformProcess::Sleep(0.05f);
			if (SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 100, 100, SWP_NOSIZE)) {
				i++;
			}
		}
	}



	FORCEINLINE TStatId GetStatId() const
	{
		RETURN_QUICK_DECLARE_CYCLE_STAT(MoveDialogTask, STATGROUP_ThreadPoolAsyncTasks);
	}
};

void UCADBIMViewerBPFuncLib::MoveDatasmithDialog()
{
	auto task = new FAutoDeleteAsyncTask<MoveDialogTask>();
	task->StartBackgroundTask();
}

void UCADBIMViewerBPFuncLib::RenameActor(AActor* actor, FString name)
{
	actor->Rename(*name);
#if WITH_EDITOR
	actor->SetActorLabel(name);
#endif
}
