// Copyright 1998-2019 Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;

public class SRDisplaySamples : ModuleRules
{
	public SRDisplaySamples(ReadOnlyTargetRules Target) : base(Target)
	{
		PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;
#if UE_5_5_OR_LATER
		CppStandard = CppStandardVersion.Cpp20;
#else
		CppStandard = CppStandardVersion.Cpp17;
#endif

		PublicDependencyModuleNames.AddRange(new string[]
		{
			"Core",
			"CoreUObject",
			"Engine",
			"InputCore",
			"SRDisplayModule",
			"XRDisplayModule",
			"RHI",
			"RenderCore",
			"HeadMountedDisplay",
			"EnhancedInput",
			"UMG",
			"Slate",
			"SlateCore"
		});
		if (ReadOnlyBuildVersion.Current.MajorVersion == 5 && ReadOnlyBuildVersion.Current.MinorVersion >= 3)
		{
			PrivateDependencyModuleNames.Add("XRBase");
		}

		PrivateDependencyModuleNames.AddRange(new string[] {  });
	}
}
