/*
 * Copyright 2023 Sony Corporation
 */

#pragma once

 // <-- Engine Header -->
#include <Engine.h>
#include <CoreMinimal.h>
#include <Widgets/SWindow.h>
#include "ClearQuad.h"
#include "CommonRenderResources.h"
#include "Delegates/IDelegateInstance.h"

class UTextureRenderTarget2D;
class FRHICommandListImmediate;
class SSample2DSceneViewport;

class FSample2DWindow
{
public:
	static void Initialize(FVector2D Resolution, FIntRect ScreenPosition);
	static void Finalize();
	static FSample2DWindow* GetPlayWindow();

public:
	FSample2DWindow(FVector2D Resolution);
	~FSample2DWindow();

	TSharedPtr<SWindow> GetWindow();
	UTextureRenderTarget2D* GetRenderTarget();

	void RenderTexture_RenderThread(FRHICommandListImmediate& RHICmdList);
#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 1
	void RenderingSRDisplay2DWindow(FRHICommandListImmediate& RHICmdList, FTextureRHIRef SrcTexture);
#else
	void RenderingSRDisplay2DWindow(FRHICommandListImmediate& RHICmdList, FTexture2DRHIRef SrcTexture);
#endif

#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 5
	void RenderingSRDisplay2DWindow_RenderTread(FRDGBuilder& GraphBuilder, SWindow& window, FRDGTexture* Texture);
	void RenderTexture_RenderThread(FRDGBuilder& GraphBuilder);
#endif

	static void RegisterDelegate();
	static void DeleteDelegate();

private:
	void OnWindowClosed(const TSharedRef<SWindow>& InWindow);

#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 1
	void CopySRDisplayTexture(FRHICommandListImmediate& RHICmdList, FRHITexture* TargetTexture, FRHITexture* SrcTexture, FVector2D WindowSize) const;
#else
	void CopySRDisplayTexture(FRHICommandListImmediate& RHICmdList, FRHITexture2D* TargetTexture, FRHITexture2D* SrcTexture, FVector2D WindowSize) const;
#endif

private:

	static TSharedPtr<FSample2DWindow> PlayWindow;

	TSharedPtr<SWindow> Window;
	FOnWindowClosed InDelegate;
	TSharedPtr<SSample2DSceneViewport> PlaySceneViewport;
};