/*
 * Copyright 2023 Sony Corporation
 */

#pragma once

 // <-- Engine Header -->
#include <CoreMinimal.h>
#include <UnrealClient.h>

class UTextureRenderTarget2D;

class FSample2DViewportClient : public FViewportClient
{
public:
	FSample2DViewportClient(float SizeX, float SizeY);

	void Shutdown();

	void Tick();

	UTextureRenderTarget2D* GetRenderTarget();

	void RenderTexture_RenderThread(FRHICommandListImmediate& RHICmdList);
#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 5
	void RenderTexture_RenderThread(FRDGBuilder& GraphBuilder);
#endif

public:
	FViewport* Viewport;

private:
	UTextureRenderTarget2D* RenderTarget;

#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 5
	FCanvas* RenderCanvas;
#endif

};