/*
 * Copyright 2023 Sony Corporation
 */

#pragma once

 // <-- Engine Header -->
#include <CoreMinimal.h>
#include <Widgets/SCompoundWidget.h>
#include <Widgets/DeclarativeSyntaxSupport.h>

class SViewport;
class FSceneViewport;
class UTextureRenderTarget2D;
class FRHICommandListImmediate;
class FSample2DViewportClient;

class SSample2DSceneViewport : public SCompoundWidget
{
public:

	SLATE_BEGIN_ARGS(SSample2DSceneViewport) { }
	SLATE_END_ARGS()

public:

	void Construct(const FArguments& InArgs);

	void Init(float SizeX, float SizeY);

	void Shutdown();

	virtual void Tick(const FGeometry& AllottedGeometry, const double InCurrentTime, const float InDeltaTime) override;

	UTextureRenderTarget2D* GetRenderTarget();

	void RenderTexture_RenderThread(FRHICommandListImmediate& RHICmdList);
#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 5
	void RenderTexture_RenderThread(FRDGBuilder& GraphBuilder);
#endif

	FViewport* GetViewport();

private:

	TSharedPtr<SViewport> Viewport;
	TSharedPtr<FSceneViewport> SceneViewport;
	TSharedPtr<FSample2DViewportClient> PlayViewportClient;
};