/*
 * Copyright 2023 Sony Corporation
 */

#include "Window/SRDisplaySample2DViewportClient.h"

// <-- Engine Header -->
#include <Engine/Engine.h>
#include <Engine/TextureRenderTarget2D.h>
#include <Engine/GameViewportClient.h>
#include <CanvasTypes.h>
#include <CanvasItem.h>
#include <Framework/Application/SlateApplication.h>
#include <GameFramework/InputSettings.h>
#include <GenericPlatform/GenericApplication.h>
#include <InputCoreTypes.h>
#include <Windows/WindowsHWrapper.h>
#include "Kismet/GameplayStatics.h"
#include "GameFramework/PlayerController.h"

FSample2DViewportClient::FSample2DViewportClient(float SizeX, float SizeY)
	: Viewport(nullptr)
{
	RenderTarget = NewObject<UTextureRenderTarget2D>(GetTransientPackage(), NAME_None, RF_Transient);
	RenderTarget->RenderTargetFormat = RTF_RGBA16f;
	RenderTarget->OverrideFormat = PF_A2B10G10R10;
	RenderTarget->InitAutoFormat(SizeX, SizeY);
	RenderTarget->ClearColor = FLinearColor::Black;
	RenderTarget->UpdateResource();
	RenderTarget->AddToRoot();
}

void FSample2DViewportClient::Shutdown()
{
	if (RenderTarget)
	{
		RenderTarget->RemoveFromRoot();
		RenderTarget = nullptr;
	}

	Viewport = nullptr;
}

void FSample2DViewportClient::Tick()
{
	
}

UTextureRenderTarget2D* FSample2DViewportClient::GetRenderTarget()
{
	return RenderTarget;
}

void FSample2DViewportClient::RenderTexture_RenderThread(FRHICommandListImmediate& RHICmdList)
{
#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 4
	if (RenderTarget && RenderTarget->GetResource() && Viewport)
#else
	if (RenderTarget && RenderTarget->Resource && Viewport)
#endif
	{
		if (Viewport->GetSizeXY().X == 0 || Viewport->GetSizeXY().Y == 0) {
			return;
		}

#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 4
		RenderTarget->GetResource()->bIgnoreGammaConversions = true;
#else
		RenderTarget->Resource->bIgnoreGammaConversions = true;
#endif

		UWorld* ViewportWorld = GetWorld();
#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 3
		FCanvas Canvas(Viewport, nullptr, ViewportWorld, ViewportWorld ? ViewportWorld->GetFeatureLevel() : GMaxRHIFeatureLevel, FCanvas::CDM_DeferDrawing, ShouldDPIScaleSceneCanvas() ? GetDPIScale() : 1.f);
#else
		FCanvas Canvas(Viewport, nullptr, ViewportWorld, ViewportWorld ? ViewportWorld->FeatureLevel.GetValue() : GMaxRHIFeatureLevel, FCanvas::CDM_DeferDrawing, ShouldDPIScaleSceneCanvas() ? GetDPIScale() : 1.f);
#endif

		Canvas.SetRenderTargetRect(FIntRect(0, 0, Viewport->GetSizeXY().X, Viewport->GetSizeXY().Y));
		{
			Canvas.SetAllowedModes(0);
			FCanvasTileItem TileItem(
				FVector2D::ZeroVector,
#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 4
				RenderTarget->GetResource(),
#else
				RenderTarget->Resource,
#endif
				Viewport->GetSizeXY(),
				FLinearColor::White);
			TileItem.BlendMode = ESimpleElementBlendMode::SE_BLEND_Opaque;
			Canvas.DrawItem(TileItem);
		}
		Canvas.Flush_RenderThread(RHICmdList, true);
	}
}

#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 5
void FSample2DViewportClient::RenderTexture_RenderThread(FRDGBuilder& GraphBuilder)
{
	if (RenderTarget && RenderTarget->GetResource() && Viewport)
	{
		if (Viewport->GetSizeXY().X == 0 || Viewport->GetSizeXY().Y == 0) {
			return;
		}

		RenderTarget->GetResource()->bIgnoreGammaConversions = true;

		UWorld* ViewportWorld = GetWorld();
		RenderCanvas = new FCanvas(Viewport, nullptr, ViewportWorld, ViewportWorld ? ViewportWorld->GetFeatureLevel() : GMaxRHIFeatureLevel, FCanvas::CDM_DeferDrawing, ShouldDPIScaleSceneCanvas() ? GetDPIScale() : 1.f);
		RenderCanvas->SetRenderTargetRect(FIntRect(0, 0, Viewport->GetSizeXY().X, Viewport->GetSizeXY().Y));
		{
			RenderCanvas->SetAllowedModes(0);
			FCanvasTileItem TileItem(
				FVector2D::ZeroVector,
				RenderTarget->GetResource(),
				Viewport->GetSizeXY(),
				FLinearColor::White);
			TileItem.BlendMode = ESimpleElementBlendMode::SE_BLEND_Opaque;
			RenderCanvas->DrawItem(TileItem);
		}
		RenderCanvas->Flush_RenderThread(GraphBuilder, true);
	}
}
#endif
