/*
 * Copyright 2023 Sony Corporation
 */


#include "Window/SRDisplaySample2DSceneViewport.h"
#include "Window/SRDisplaySample2DViewportClient.h"

// <-- Engine Header -->
#include <Slate/SceneViewport.h>
#include <Widgets/SViewport.h>

void SSample2DSceneViewport::Construct(const FArguments& InArgs)
{
	// Create Viewport Widget
	Viewport = SNew(SViewport)
		.IsEnabled(true)
		.EnableGammaCorrection(false)
		.ShowEffectWhenDisabled(false)
		.EnableBlending(true);
}

void SSample2DSceneViewport::Init(float SizeX, float SizeY)
{
	// Create Viewport Client
	PlayViewportClient = MakeShareable(new FSample2DViewportClient(SizeX, SizeY));

	// Create Scene Viewport
	SceneViewport = MakeShareable(new FSceneViewport(PlayViewportClient.Get(), Viewport));

	// Assign SceneViewport to Viewport widget. It needed for rendering
	Viewport->SetViewportInterface(SceneViewport.ToSharedRef());
	PlayViewportClient->Viewport = SceneViewport.Get();

	// Assing Viewport widget for our custom PlayScene Viewport
	this->ChildSlot
		[
			Viewport.ToSharedRef()
		];
}

UTextureRenderTarget2D* SSample2DSceneViewport::GetRenderTarget()
{
	return PlayViewportClient->GetRenderTarget();
}


void SSample2DSceneViewport::Shutdown()
{
	if (SceneViewport.IsValid())
	{
		SceneViewport.Reset();
		SceneViewport = nullptr;
	}

	if (PlayViewportClient.IsValid())
	{
		PlayViewportClient->Shutdown();
		PlayViewportClient.Reset();
		PlayViewportClient = nullptr;
	}

	if (Viewport.IsValid())
	{
		Viewport.Reset();
		Viewport = nullptr;
	}
}

void SSample2DSceneViewport::Tick(const FGeometry& AllottedGeometry, const double InCurrentTime, const float InDeltaTime)
{
	SWidget::Tick(AllottedGeometry, InCurrentTime, InDeltaTime);
	if (PlayViewportClient.IsValid()) {
		PlayViewportClient->Tick();
	}
	
	static bool bFirstTime = true;
	if (bFirstTime)
	{
		bFirstTime = false;
		FSlateApplication::Get().RegisterGameViewport(Viewport.ToSharedRef());
	}
}

void SSample2DSceneViewport::RenderTexture_RenderThread(FRHICommandListImmediate& RHICmdList)
{
#if ENGINE_MAJOR_VERSION == 4 || (ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION < 5)
	PlayViewportClient->RenderTexture_RenderThread(RHICmdList);
#endif
}

#if ENGINE_MAJOR_VERSION == 5 && ENGINE_MINOR_VERSION >= 5
void SSample2DSceneViewport::RenderTexture_RenderThread(FRDGBuilder& GraphBuilder)
{
	PlayViewportClient->RenderTexture_RenderThread(GraphBuilder);
}
#endif

FViewport* SSample2DSceneViewport::GetViewport()
{
	if (PlayViewportClient.IsValid())
	{
		return PlayViewportClient->Viewport;
	}
	return nullptr;
}