
const char* StandardMaterialVertexShader = R"***(#version 330
in vec3 in_Pos;
in vec3 in_Nor;
out vec3 vs_Pos;
out vec3 vs_Nor;
uniform mat4 u_WV;
uniform mat4 u_WVP;
void main() {
	vs_Pos = (u_WV * vec4(in_Pos, 1.0)).xyz;
	vs_Nor = mat3(u_WV) * in_Nor;
	gl_Position = u_WVP * vec4(in_Pos, 1.0);
}
)***";

const char* StandardMaterialFragmentShader = R"***(#version 330
in vec3 vs_Pos;
in vec3 vs_Nor;

out vec4 out_Color;

uniform vec4 u_Diffuse;

#define LIGHT_NUM (4)
uniform vec3 u_LightDir[LIGHT_NUM];
uniform vec3 u_LightColor[LIGHT_NUM];

struct Material {
	vec4 diffuse;
};

struct Light {
	vec3 direction;
	vec3 color;
	bool use;
};

struct ReflectedLight {
	vec3 diffuse;
};

void Lambert(const in Light light, const in vec3 normal, const in Material material, inout ReflectedLight reflectedLight) {
	float NL = max(0.0, min(1.0, dot(normal, light.direction)));
	reflectedLight.diffuse += NL * light.color * material.diffuse.rgb;
}

void main() {
	Material material;
	material.diffuse = u_Diffuse;

	Light light[LIGHT_NUM];
	for (int i = 0; i < LIGHT_NUM; i++) {
		light[i].direction = -normalize(u_LightDir[i]);
		light[i].color = u_LightColor[i];
		light[i].use = (light[i].color != vec3(0.0));
	}

	ReflectedLight reflectedLight;
	reflectedLight.diffuse = vec3(0.0);

	vec3 normal = normalize(vs_Nor);
	for (int i = 0; i < LIGHT_NUM; i++) {
		if (light[i].use) {
			Lambert(light[i], normal, material, reflectedLight);
		}
	}

	out_Color = vec4(reflectedLight.diffuse, material.diffuse.a);
}
)***";
