
const char* HomographyCopyVertexShader = R"***(#version 330
in vec2 in_Pos;
out vec2 vs_UV;
uniform mat3 u_HomographyMatrix;
void main() {
	vec2 p = in_Pos;
	float s =  u_HomographyMatrix[0][2] * p.x + u_HomographyMatrix[1][2] * p.y + u_HomographyMatrix[2][2];
	float x = (u_HomographyMatrix[0][0] * p.x + u_HomographyMatrix[1][0] * p.y + u_HomographyMatrix[2][0]) / s;
	float y = (u_HomographyMatrix[0][1] * p.x + u_HomographyMatrix[1][1] * p.y + u_HomographyMatrix[2][1]) / s;
	gl_Position = vec4(2.0 * (x - 0.5), 2 * (0.5 - y), 0.0, 1.0);
	vs_UV = vec2(gl_Position.x, gl_Position.y);
}
)***";

const char* HomographyCopyFragmentShader = R"***(#version 330
in vec2 vs_UV;
out vec4 out_Color;
uniform sampler2D u_Tex;
uniform mat3 u_InvHomographyMatrix;
void main() {
	vec2 p = (vs_UV + 1.0) * 0.5;
	p.y = 1.0 - p.y;
	float s =  u_InvHomographyMatrix[0][2] * p.x + u_InvHomographyMatrix[1][2] * p.y + u_InvHomographyMatrix[2][2];
	float u = (u_InvHomographyMatrix[0][0] * p.x + u_InvHomographyMatrix[1][0] * p.y + u_InvHomographyMatrix[2][0]) / s;
	float v = (u_InvHomographyMatrix[0][1] * p.x + u_InvHomographyMatrix[1][1] * p.y + u_InvHomographyMatrix[2][1]) / s;
	vec2 uv = vec2(u, 1.0 - v);
	out_Color = texture(u_Tex, uv);
}
)***";
