/**
 * Sony CONFIDENTIAL
 *
 * Copyright 2022 Sony Corporation
 *
 * DO NOT COPY AND/OR REDISTRIBUTE WITHOUT PERMISSION.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef XR_API_WRAPPER_UTILITY_H_
#define XR_API_WRAPPER_UTILITY_H_

#include "xr-runtime-common/xr_api_defs.h"

XR_DEFINE_HANDLE(SonyOzSessionHandle);

namespace sony::oz::xr_runtime::utility {
/**
 * \~Japanese
 * @brief セッションが利用可能になるまで待機する。
 * @param[in] session セッションのハンドルを渡す。
 * @return セッションが利用可能になると true が返ります。セッションが利用出来ない場合は false が返ります。
 * @details
 * BeginSession() 呼び出し後、利用可能になるまで待つ必要があります。
 * @attention
 * \~English
 * @brief Wait until the session is available.
 * @param[in] session Pass the session handle.
 * @return True is returned when the session is available. If the session is not available, false is returned.
 * @details
 * After calling BeginSession(), you must wait until it becomes available.
 * @attention
 */
bool WaitUntilRunningState(SonyOzSessionHandle handle);
}  // namespace sony::oz::xr_runtime::utility

#endif  // XR_API_WRAPPER_UTILITY_H_
