# Spatial Reality Display Sample Program Design

## Overview

The Spatial Reality Display sample programs implement the following functions

- View 3D objects stereoscopically using the Spatial Reality Display SDK
- Use OpenGL 3.3 or later for 3D display
- Can be built with Visual Studio 2019

## Used libraries

Spatial Reality Display Sample uses several external libraries.

### GLFW

- Version: 3.3.9
- URL: <https://www.glfw.org/>
- License: zlib/libpng license

GLFW is used for OpenGL initialization, window creation, and the drawing loop.

### GLM

- Version: 0.9.9.8
- URL: <https://github.com/g-truc/glm>
- License: MIT License

GLM is a 3D math library.
It performs the same calculations as GLSL.

### GL3W

- URL: <https://github.com/skaslev/gl3w>
- License: Public domain

GL3W loads OpenGL3.3 functions.
GL3W is generated by a Python script.

- hash: 3a33275633ce4be433332dc776e6a5b3bdea6506
- Generate date: 2024/02/16

## Program overview

The program consists of the following

|Class|Content|Source|
|---|---|---|
|SampleApp|Application class|main.cpp|
|GLManager|OpenGL Wrapper class|GLManager.h / .cpp|

### SampleApp

SampleApp is the main processing for the sample.
It implements the following functions:

- Initialization/termination of Spatial Reality Display SDK
- Initialization of OpenGL
- Creation of drawing objects
- Load shaders
- Drawing process

The process flow is as follows:

1. Program start
2. Spatial Reality Display Runtime initialization
3. Initialize 3D objects
4. Drawing process (loop until end of program)
5. Terminate

In the rendering process, the 3D scene is rendered using the tracking information obtained from Spatial Reality Display Runtime.
The process flow is as follows:

1. Obtain tracking information from Spatial Reality Display Runtime.
2. Create View / Projection matrix from the tracking information.
3. Draw objects visible to the left and right eyes.
4. Perform homography transformation on the drawing result.
5. Transmit the converted homography image to Spatial Reality Display Runtime.
6. Spatial Reality Display Runtime displays the combined stereoscopic image.

### GLManager

GLManager manages OpenGL resources and implements common processes for drawing.

#### ShaderProgram resource

OpenGL shader program.
It reads shader code and creates ShaderProgram resources.
The following shaders are available:

|Name|Content|
|---|---|
|StandardMaterialShader|Draw 3D model|
|HomographyCopyShader|Homography transformation|
|QuadCopyShader|Copy images.(Used to create side-by-side images.)|

#### DrawObject resource

3D drawing object.
It has the following OpenGL resources for drawing:

|Name|Content|
|---|---|
|m_vbo(Vertex Buffer Object)|Vertex data|
|m_ibo(Index Buffer Object)|Index data|
|m_vao(Vertex Array Object)|Vertex bind data|
|m_transform|Object transform (4x4 matrix)|
|m_diffuse|Object color|

#### FrameBuffer resource

OpenGL framebuffer.
It also has a texture object for use as a texture.
The framebuffer is used for the following drawings:

- Where to draw the scene
- Where to draw homographic transformations
- Destination for Side-by-Side images
- To render stereoscopic composite images

#### Render 3D

This is a function that draws a 3D object.

```cpp
GLManager::Draw(const DrawObject& drawObject, const SceneInfo& sceneInfo)
```

The display position of the 3D object is specified by `DrawObject::m_transform`.
Draws the object using the View/Projection matrix set in the `SceneInfo`.

#### 4 Vertex drawing

4-vertex drawing specifies 4 vertices in a 2D coordinate system to draw a surface.
This is used when copying the drawing surface, etc.

```cpp
struct QuadVertex
{
    glm::vec2 m_position;
    glm::vec2 m_uv;
};

struct Quad
{
    /*
    * [0]: Left Top
    * [1]: Left Bottom
    * [2]: Right Top
    * [3]: Right Bottom
    */
    QuadVertex m_quad[4];
};
```

Use this feature to:

- Homography transformation
- used to create side-by-side images

Use the `SampleApp::CopyQuad` function to draw 4 vertices.

```cpp
SampleApp::CopyQuad(GLuint fbo, uint32_t w, uint32_t h, GLuint texture, const Quad& quad)
```
