# Spatial Reality Display サンプル プログラム設計書

## 概要

Spatial Reality Display サンプルプログラムでは次の機能を実装します。

- Spatial Reality Display SDK を用い3Dオブジェクトを立体視する
- 3D の表示には OpenGL 3.3 以降を使用する
- Visual Studio 2019 でビルドできる

## 使用ライブラリ

サンプルを簡潔に実装するため、いくつかのサンプルライブラリを使用します。

### GLFW

- Version: 3.3.9
- URL: <https://www.glfw.org/>
- ライセンス: zlib/libpng license

OpenGL の初期化を行うために使用します。

また、表示ウィンドウ、描画ループについても GLFW を使用します。

### GLM

- Version: 0.9.9.8
- URL: <https://github.com/g-truc/glm>
- ライセンス: MIT License

3D 計算のための数学ライブラリです。

glsl のベクトル、マトリクス型と同じ使い方ができます。

### GL3W

- URL: <https://github.com/skaslev/gl3w>
- ライセンス: Public domain

Windows API で対応していない OpenGL 3.3 の関数をロードするために使用します。

GL3W は python スクリプトで、最新の OpenGL 関数をロードするソースコードを生成します。

- gl3wのhash: 3a33275633ce4be433332dc776e6a5b3bdea6506
- 生成日: 2024/02/16

## プログラム概要

プログラムは以下のように構成されます。

|クラス名|機能|ソース|
|---|---|---|
|SampleApp|サンプルアプリケーション|main.cpp|
|GLManager|OpenGL の簡易ラッパー|GLManager.h / .cpp|

### SampleApp について

SampleApp はサンプルのメイン処理となります。
以下の機能を実装します。

- Spatial Reality Display SDK の初期化/終了処理
- OpenGL の初期化処理
- 描画オブジェクトの作成
- シェーダーのロード
- 描画処理

処理の流れは以下のようになります。

1. プログラム開始
2. Spatial Reality Display Runtime 初期化
3. 3D オブジェクト初期化
4. 描画処理 (プログラム終了までループ)
5. 終了処理

描画処理では Spatial Reality Display Runtime より取得したトラッキング情報により3Dシーンを描画します。
処理の流れは以下のようになります。

1. Spatial Reality Display Runtime よりトラッキング情報の取得
2. トラッキング情報より View / Projection マトリクスを作成
3. 左右の目から見えるオブジェクトを描画
4. 描画結果にホモグラフィ変換を行う
5. Spatial Reality Display Runtime へホモグラフィ変換後の画像を送信する
6. Spatial Reality Display Runtime により合成された立体視画像を表示する

### GLManager について

GLManager では主に OpenGL のリソースを管理し、描画の共通処理を実装します。

#### ShaderProgram リソース

OpenGL のシェーダープログラムです。

シェーダーコードを読み込み、ShaderProgram リソースを作成します。

以下のシェーダーがあります。

|名前|機能|
|---|---|
|StandardMaterialShader|3Dオブジェクトの描画に使用|
|HomographyCopyShader|ホモグラフィ変換に使用|
|QuadCopyShader|画像コピーシェーダー(サイドバイサイド画像を作成するために使用)|

#### DrawObject リソース

3D オブジェクトの描画用のリソースをまとめます。

描画のため以下の OpenGL リソースをまとめます。

|名前|機能|
|---|---|
|m_vbo(Vertex Buffer Object)|頂点データ|
|m_ibo(Index Buffer Object)|頂点インデックスデータ|
|m_vao(Vertex Array Object)|頂点のバインドデータ|

また、描画の表示位置と、面の色情報も含まれます。

|名前|機能|
|---|---|
|m_transform|オブジェクトの姿勢 (4x4マトリクスで指定します)|
|m_diffuse|オブジェクトの色|

#### FrameBuffer リソース

OpenGL のフレームバッファを管理します。

テクスチャとしても使用するため、テクスチャオブジェクトもまとめて管理します。

フレームバッファは以下の描画で使用されます。

- シーンの描画先
- ホモグラフィ変換の描画先
- サイドバイサイド画像の描画先
- 立体視合成画像の描画先

#### 3D 描画について

以下の関数にてオブジェクトを描画します。

```cpp
GLManager::Draw(const DrawObject& drawObject, const SceneInfo& sceneInfo)
```

オブジェクトの表示位置は `DrawObject` の `m_transform` で指定します。

SceneInfo に設定された View/Projection マトリクスを使用してオブジェクトを描画します。

#### 4頂点描画について

4頂点描画とは2D座標系で4頂点を指定して面を描画します。
描画面をコピーする際等に使用します。

4頂点は Quad 構造体で指定します。

```cpp
struct QuadVertex
{
    glm::vec2 m_position;
    glm::vec2 m_uv;
};

struct Quad
{
    /*
    * [0]: Left Top
    * [1]: Left Bottom
    * [2]: Right Top
    * [3]: Right Bottom
    */
    QuadVertex m_quad[4];
};
```

サンプルでは以下の4頂点描画を行います。

- ホモグラフィ変換時
- サイドバイサイド画像作成時

シェーダーが違うのみで、頂点データ、描画方法は同じため以下の関数でまとめています。

```cpp
SampleApp::CopyQuad(GLuint fbo, uint32_t w, uint32_t h, GLuint texture, const Quad& quad)
```
