/**
 * Sony CONFIDENTIAL
 *
 * Copyright 2022-2024 Sony Corporation
 *
 * DO NOT COPY AND/OR REDISTRIBUTE WITHOUT PERMISSION.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#pragma once

#include "xr-runtime-common/xr_api_defs.h"

XR_DEFINE_HANDLE(SonyOzSessionHandle);

namespace sony::oz::xr_runtime {
    /**
     * @brief Get PerformancePriority mode is enabled or not.
     * @param[out] platform_id Indicating XR platform. It will always be "Spatial Reality Display"
     * @param[out] session Pass the session handle.
     * @param[in] enabled true: PerformancePriority is enabled, false: PerformancePriority is disabled or not supported.
     * @return SonyOzResult
     * @details
     * Get PerformancePriority mode is enabled or not.
     * @attention
     */
    SonyOzResult GetPerformancePriority(SonyOzPlatformId platform_id, SonyOzSessionHandle session, bool* enable);

    /**
     * @brief Get wallmount mode is enabled or not.
     * @param[out] platform_id Indicating XR platform. It will always be "Spatial Reality Display"
     * @param[out] session Pass the session handle.
     * @param[in] enabled true: wallmount is enabled, false: wallmount mode is disabled or not supported.
     * @return SonyOzResult
     * @details
     * Get wallmount mode is enabled or not.
     * @attention
     */
    SonyOzResult GetWallmountMode(SonyOzPlatformId platform_id, SonyOzSessionHandle session, bool* enable);

    /**
     * @brief Set wallmount mode is enabled or not.
     * @param[out] platform_id Indicating XR platform. It will always be "Spatial Reality Display"
     * @param[out] session Pass the session handle.
     * @param[out] enabled true: Enable wallmount mode, false: Disable wallmount mode.
     * @return SonyOzResult
     * @details
     * Set wallmount mode is enabled or not.
     * @attention
     */
    SonyOzResult SetWallmountMode(SonyOzPlatformId platform_id, SonyOzSessionHandle session, const bool enable);
}
